#!/bin/bash
#########################################
# Copyright (c) 2012-2015 Huawei .
# All rights reserved.
#
# Please send feedback to http://www.huawei.com
#
# Function
# revise note
########################################

set +x
WORK_PATH=$(cd "$(dirname "$BASH_SOURCE")";pwd)

source /opt/huawei-data-protection/ebackup/bin/ebackup_ms_profile.sh

G_RESOURCE_NAME="floatIp"
G_LOG_PATH=${G_HOME_PATH}/logs
G_HCP_ROOT=${G_HOME_PATH}
G_HCP_CONFIG_INI=${G_PRIVATE_CONF_FILE}
G_CONF_HA_SCRIPT_PATH=${G_HCP_ROOT}/ha/module/hacom/script
G_HAARB_XML=${G_HCP_ROOT}/ha/module/haarb/conf/haarb.xml
G_IFCONFIG="$(which ifconfig)"
G_HA_MODE=""
G_ARPING="$(which arping)"
G_NDSEND=""
source $G_HCP_ROOT/sbin/log.sh
source $G_HCP_ROOT/bin/event_lib.sh

if [ -L "${G_HCP_CONFIG_INI}" ];then
    echo "symbol link File."
    exit 1
fi

G_HCPMANAGEMENT_PLANE="HCPManagementPlane"
G_FLOATIP_IP_NAME="FloatIP"
G_FLOAT_IP_BAK=$G_HCP_ROOT/conf/floatIpBak
G_HCP_PROCESS_ACCOUNT=hcpprocess

G_MANAGEMENT_IP=""
G_MANAGE_FLOAT_IP=""
G_MANAGE_FIP_PORT=""
G_MANAGE_FIP_MASK=""
G_OS_TYPE="" #ϵͳ
G_MANAGEMENT_ETH_NAME=""
G_CONF_PATH=${G_HCP_ROOT}/conf/hcpconf.ini
IP_FLAG=""

if [ -L "${G_CONF_PATH}" ];then
    echo "symbol link File."
    exit 1
fi

function checkout_os_type()
{
    if [[ -f "/etc/SuSE-release" ]]; then
        G_OS_TYPE="SuSE"
    fi
    if [[ -f "/etc/euleros-release" ]]; then
        G_OS_TYPE="Euler"
    fi
}

function check_ip_address()
{
    if [ $# -ne 1 ];then
       return 1
    fi
    local L_IP="$1"

    # It does not include the network address of the D and E
    if  echo ${L_IP} | grep -E '^(22[0-3]|2[0-1][0-9]|19[2-9]|19[0-9]|1[2-8][0-9]|1[0-2][0-7]|[0-9][0-9]|[0-9])\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])$' > /dev/null 2>&1; then
        if [[ "X${L_IP}" != "X0.0.0.0" ]] &&\
           [[ "X${L_IP}" != "X255.255.255.255" ]] &&\
           [[ "X${L_IP}" != "X127.0.0.1" ]];then
            return 0
        else
            return 1
        fi
    elif echo ${L_IP} | grep -E '^((([0-9a-fA-F]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9a-fA-F]{1,4}:){6}((([0-9]{1,3}\.){3}[0-9]{1,4})|([0-9a-fA-F]{1,4})|:))|(([0-9a-fA-F]{1,4}:){5}:((([0-9a-fA-F]{1,4})?)|([0-9a-fA-F]{1,4}:[0-9a-fA-F]{1,4})|(([0-9]{1,3}\.){3}[0-9]{1,4})))|(([0-9a-fA-F]{1,4}:){4}:((([0-9a-fA-F]{1,4})?)|(([0-9a-fA-F]{1,4}:){1,2}[0-9a-fA-F]{1,4})|(([0-9a-fA-F]{1,4}:)?([0-9]{1,3}\.){3}[0-9]{1,4})))|(([0-9a-fA-F]{1,4}:){3}:((([0-9a-fA-F]{1,4}:){0,2}([0-9]{1,3}\.){3}[0-9]{1,4})|(([0-9a-fA-F]{1,4}:){0,3}[0-9a-fA-F]{1,4})|$))|(([0-9a-fA-F]{1,4}:){2}:((([0-9a-fA-F]{1,4}:){0,3}([0-9]{1,3}\.){3}[0-9]{1,4})|(([0-9a-fA-F]{1,4}:){0,4}[0-9a-fA-F]{1,4})|$))|(([0-9a-fA-F]{1,4}:){1}:((([0-9a-fA-F]{1,4}:){0,4}([0-9]{1,3}\.){3}[0-9]{1,4})|(([0-9a-fA-F]{1,4}:){0,5}[0-9a-fA-F]{1,4})|$))|(::((([0-9a-fA-F]{1,4}:){0,5}([0-9]{1,3}\.){3}[0-9]{1,4})|(([0-9a-fA-F]{1,4}:){0,6}[0-9a-fA-F]{1,4})|$)))$' > /dev/null 2>&1; then
        if [[ "X${L_IP}" != "X::" ]] &&\
           [[ "X${L_IP}" != "X::FF:FF" ]] &&\
                   [[ "X${L_IP}" != "X::ff:ff" ]] &&\
           [[ "X${L_IP}" != "X::1" ]];then
            return 0
        else
            return 1
        fi

    else
        return 1
    fi
}

function save_iptables()
{
    log_info "Begin to save iptables."
    local iptable_file="/opt/huawei-data-protection/ebackup/conf/floatip_iptables_backup"
    if [ -L ${iptable_file} ];then
        log_error "symbol link File." 
        return 1
    fi 
    iptables-save > ${iptable_file}
    if [ $? -ne 0 ]; then
    log_error "save iptables failed."
        return 1
    fi
    return 0
}

function restore_iptables()
{
    log_info "Begin to restore iptables."
    iptables-restore < /opt/huawei-data-protection/ebackup/conf/floatip_iptables_backup
    if [ $? -ne 0 ]; then
        log_error "restore iptables failed."
        return 1
    fi
    remove_backup_iptables  
    return 0
}

function remove_backup_iptables()
{
    log_info "Begin to remove backup iptables."
    rm -rf /opt/huawei-data-protection/ebackup/conf/floatip_iptables_backup
    return 0
}

function get_net_no() 
{ 
    local ALL_NET_NO="192.168.1.0"
    local MANAGE_IPMASK="$1 $2"

    ALL_NET_NO=$(echo $MANAGE_IPMASK |awk -F '[ .]+' 'BEGIN{OFS="."} END{print and($1,$5),and($2,$6),and($3,$7),and($4,$8)}')
    echo "${ALL_NET_NO}"
} 

#******************************************************************#
# Function: check_ip_addr
# Description: The function check one IP whether is valid
# Input Parameters: IPAddr
# Return : 0 IPAddr is valid IP
#          1 IPAddr is not valid IP
#******************************************************************#
check_ip_addr() 
{
    if [ $IP_FLAG = 'ipv4' ];then
        ipaddr=$1
        echo ${ipaddr}|grep "^\([0-9]\{1,3\}\.\)\{3\}[0-9]\{1,3\}$" > /dev/null;
        if [ $? -ne 0 ]; then
            return 1
        fi
        
        num1=`echo ${ipaddr}|awk -F . '{print $1}'`
        num2=`echo ${ipaddr}|awk -F . '{print $2}'`
        num3=`echo ${ipaddr}|awk -F . '{print $3}'`
        num4=`echo ${ipaddr}|awk -F . '{print $4}'`
        for num in ${num1} ${num2} ${num3} ${num4}
        do
            if [ ${num} -gt 255 ] || [ ${num} -lt 0 ]; then 
                return 1
            fi
        done
        return 0
    else
        ipaddr=$1
        echo ${ipaddr}| grep -E '^((([0-9a-fA-F]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9a-fA-F]{1,4}:){6}((([0-9]{1,3}\.){3}[0-9]{1,4})|([0-9a-fA-F]{1,4})|:))|(([0-9a-fA-F]{1,4}:){5}:((([0-9a-fA-F]{1,4})?)|([0-9a-fA-F]{1,4}:[0-9a-fA-F]{1,4})|(([0-9]{1,3}\.){3}[0-9]{1,4})))|(([0-9a-fA-F]{1,4}:){4}:((([0-9a-fA-F]{1,4})?)|(([0-9a-fA-F]{1,4}:){1,2}[0-9a-fA-F]{1,4})|(([0-9a-fA-F]{1,4}:)?([0-9]{1,3}\.){3}[0-9]{1,4})))|(([0-9a-fA-F]{1,4}:){3}:((([0-9a-fA-F]{1,4}:){0,2}([0-9]{1,3}\.){3}[0-9]{1,4})|(([0-9a-fA-F]{1,4}:){0,3}[0-9a-fA-F]{1,4})|$))|(([0-9a-fA-F]{1,4}:){2}:((([0-9a-fA-F]{1,4}:){0,3}([0-9]{1,3}\.){3}[0-9]{1,4})|(([0-9a-fA-F]{1,4}:){0,4}[0-9a-fA-F]{1,4})|$))|(([0-9a-fA-F]{1,4}:){1}:((([0-9a-fA-F]{1,4}:){0,4}([0-9]{1,3}\.){3}[0-9]{1,4})|(([0-9a-fA-F]{1,4}:){0,5}[0-9a-fA-F]{1,4})|$))|(::((([0-9a-fA-F]{1,4}:){0,5}([0-9]{1,3}\.){3}[0-9]{1,4})|(([0-9a-fA-F]{1,4}:){0,6}[0-9a-fA-F]{1,4})|$)))$' > /dev/null; 
        if [ $? -ne 0 ]; then
            return 1
        fi
        return 0
    fi
}


#******************************************************************#
# Function: set_floatip
# Description: The function to set floatIP 
# Input Parameters:
# None
# Return : 0 success
#      1 failed
#******************************************************************#
function set_floatip()
{
    local natIptables=$(sudo ${WORK_PATH}/sudofunction.sh get_iptables_input)
    if [ $IP_FLAG = 'ipv4' ];then
        log_info "[set_floatip(),$LINENO] begin set_floatIP,floatPort:${G_MANAGE_FIP_PORT},floatIP:${G_MANAGE_FLOAT_IP},mask:${G_MANAGE_FIP_MASK}"
        ping -c 3 ${G_MANAGE_FLOAT_IP} >/dev/null  
        if [ $? -ne 0 ];then
            sudo ${WORK_PATH}/sudofunction.sh set_floatip ${G_MANAGE_FIP_PORT} ${G_MANAGE_FLOAT_IP} ${G_MANAGE_FIP_MASK} 
            if [ $? -ne 0 ];then
                log_error "[set_floatip(),$LINENO] set float ip  ${G_MANAGE_FLOAT_IP} failed!"
                return 1
            fi
        else
            log_warn "[set_floatip(),$LINENO]  ${G_MANAGE_FLOAT_IP} has been used somewhere,please check whether if the  floatIP is available "
        fi
            
        #check if floatIP nat to managementIP with 22 port,if not,do nat.
        local sshrules=`echo "${natIptables}" |grep  $G_MANAGE_FLOAT_IP.*dpt:22.*$G_MANAGEMENT_IP|wc -l`
            if [ $sshrules -eq 0 ];then
                sudo ${WORK_PATH}/sudofunction.sh add_iptables_nat "addnatip" ${G_MANAGE_FLOAT_IP} 22 ${G_MANAGEMENT_IP}
                if [ $? -ne 0 ];then
                    log_error "[set_floatip(),$LINENO] set iptables DNAT 22 failed!"
                    return 1
                fi
            else
                log_info "[set_floatip(),$LINENO] iptables DNAT 22 has already been seted!"
            fi
        
        log_info "[set_floatip(),$LINENO] try to flush arp!"
            
        local L_MANAGE_DEVICE_NAME=`echo ${G_MANAGE_FIP_PORT} 2>/dev/null|awk -F: '{print $1}'` 
        ${G_ARPING} -c 1 -A -I ${L_MANAGE_DEVICE_NAME} ${G_MANAGE_FLOAT_IP} >/dev/null 2>&1
        if [ $? -ne 0 ];then
            log_error "[set_floatip(),$LINENO] failed to flush arp for float ip!"
        else
            log_info "[set_floatip(),$LINENO] succeed to flush arp for float ip!"
        fi  

        log_info "[set_floatip(),$LINENO] set_floatIP success!"
        return 0
    else
        log_info "[set_floatip(),$LINENO] begin set_floatIP,floatPort:${G_MANAGE_FIP_PORT},floatIP:${G_MANAGE_FLOAT_IP},mask:${G_MANAGE_FIP_MASK}"
        ping6 -c 3 ${G_MANAGE_FLOAT_IP} >/dev/null  
        if [ $? -ne 0 ];then
            local MANAGEMENT_IP=`cat ${G_HCP_CONFIG_INI} | grep  "HCPManagementPlane=" |awk -F '|' '{print $1}' | grep "HCPManagementPlane" | awk -F '=' '{print $2}'`
            if [ -z $MANAGEMENT_IP ];then
                log_error "[set_floatip(),$LINENO] get HCPManagementPlane address form ${G_HCP_CONFIG_INI} faild"   
                return 1
            fi
            sudo ${WORK_PATH}/sudofunction.sh set_floatip ${G_MANAGE_FIP_PORT} ${G_MANAGE_FLOAT_IP} ${MANAGEMENT_IP} 
            if [ $? -ne 0 ];then
                log_error "[set_floatip(),$LINENO] set float ip  ${G_MANAGE_FLOAT_IP} failed!"
                return 1
            fi
        else
            log_warn "[set_floatip(),$LINENO]  ${G_MANAGE_FLOAT_IP} has been used somewhere,please check whether if the  floatIP is available "
        fi
            
        #check if floatIP nat to managementIP with 22 port,if not,do nat.
        local sshrules=`echo "${natIptables}" |grep  $G_MANAGE_FLOAT_IP.*dpt:22.*$G_MANAGEMENT_IP|wc -l`
        if [ $sshrules -eq 0 ];then
            sudo ${WORK_PATH}/sudofunction.sh add_iptables_nat "addnatip" ${G_MANAGE_FLOAT_IP} 22 ${G_MANAGEMENT_IP}
            if [ $? -ne 0 ];then
                log_error "[set_floatip(),$LINENO] set iptables DNAT 22 failed!"
                return 1
            fi
        else
            log_info "[set_floatip(),$LINENO] iptables DNAT 22 has already been seted!"
        fi
        
        log_info "set_floatIP success! ndsend: ${G_NDSEND} ${G_MANAGE_FIP_PORT} ${G_MANAGE_FLOAT_IP}"
        return 0
    fi
}

function recover_iptables()
{
    if [ $IP_FLAG = 'ipv4' ];then
        log_info "[recover_iptables(),$LINENO] begin recover_iptables !"
        sudo ${WORK_PATH}/sudofunction.sh add_iptables_nat "addport" ${G_MANAGEMENT_IP} 80 8080
        if [ $? -ne 0 ];then
            log_error "[recover_iptables(),$LINENO] set iptables map ${G_MANAGEMENT_IP} 80 to 8080 failed!"
            return 1
        fi
        sudo ${WORK_PATH}/sudofunction.sh add_iptables_nat "addport" ${G_MANAGEMENT_IP} 443 8088
        if [ $? -ne 0 ];then
            log_error "[recover_iptables(),$LINENO] set iptables map ${G_MANAGEMENT_IP} 443 to 8088 failed!"
            return 1
        fi
        log_info "[recover_iptables(),$LINENO] recover_iptables success !"
    else
        log_info "[recover_iptables(),$LINENO] begin recover_iptables !"

        log_info "[recover_iptables(),$LINENO] recover_iptables success !"
    fi
}


#******************************************************************#
# Function: repair
# Description: The function to be called when host abnormal 
# Input Parameters:
# None
# Return : 0 success
#      1 failed
#******************************************************************#
function repair()
{
    log_info "[repair(),$LINENO] begin repair !"
    get_floatip_information
    if [ $? -ne 0 ];then
        log_error "[repair(),$LINENO] get_floatip_information failed!"
        return 1
    fi
    set_floatip
    return $?
}

#******************************************************************#
# Function: check_internal_and_manag
# Description: The function to be called when host abnormal 
# Input Parameters:
# None
# Return : 0 success
#      1 failed
#******************************************************************#

function check_internal_and_manag()
{
    log_info "[check_internal_and_manag(),$LINENO] comming in check_internal_and_manag"
    local INTERNAL_IP=""
    INTERNAL_IP=`cat ${G_HCP_CONFIG_INI} | grep  "HCPInternalPlane=" |awk -F '|' '{print $1}' | grep "HCPInternalPlane=" | awk -F '=' '{print $2}'`
    if [ -z $INTERNAL_IP ];then
        log_error "[check_internal_and_manag(),$LINENO] get HCPInternalPlane address form ${G_HCP_CONFIG_INI} faild"    
        return 1
    fi
    check_ip_address "${INTERNAL_IP}"
    if [ $? -ne 0 ];then
        log_error "[check_internal_and_manag(),$LINENO] get HCPInternalPlane address form ${G_HCP_CONFIG_INI} faild"
        return 1
    fi
    G_MANAGEMENT_IP=`cat ${G_HCP_CONFIG_INI} | grep  "HCPManagementPlane=" |awk -F '|' '{print $1}' | grep "HCPManagementPlane" | awk -F '=' '{print $2}'`
    if [ -z $G_MANAGEMENT_IP ];then
        log_error "[check_internal_and_manag(),$LINENO] get HCPManagementPlane address form ${G_HCP_CONFIG_INI} faild"  
        return 1
    fi
    check_ip_address "${G_MANAGEMENT_IP}"
    if [ $? -ne 0 ];then
        log_error "[check_internal_and_manag(),$LINENO] get HCPInternalPlane address form ${G_HCP_CONFIG_INI} faild"
        return 1
    fi
        
    local IF_INTERNAL_IP_EXIST=""
    local IF_MANAGEMENT_IP_EXIST=""
    IF_INTERNAL_IP_EXIST=`${G_IFCONFIG} 2> /dev/null | grep -n -w $INTERNAL_IP`
    IF_MANAGEMENT_IP_EXIST=`${G_IFCONFIG} 2> /dev/null | grep -n -w $G_MANAGEMENT_IP`
        
    if [ -z "$IF_INTERNAL_IP_EXIST" ];then
        log_error "[check_internal_and_manag(),$LINENO] No $INTERNAL_IP after ifconfig"
        return 1
    fi
        
    if [ "$G_ROLE" = "active" ];then
        #check iptables
        log_info "[check_internal_and_manag(),$LINENO] start check iptables."
        local mismatch=0
        ret=0
            
        local netIptables=$(sudo ${WORK_PATH}/sudofunction.sh get_iptables_net)
        local param="dpt:80"
        ret=`echo "${netIptables}" |grep  $G_MANAGEMENT_IP.*$param.*8080|wc -l`     
        if [ $ret -eq 0 ];then
            log_error "[check_internal_and_manag(),$LINENO] Can't find match rules for $G_MANAGEMENT_IP and $param !"
            mismatch=1
        fi
            
        ret=`echo "${netIptables}" |grep  $G_MANAGE_FLOAT_IP.*$param.*8080|wc -l`   
        if [ $ret -eq 0 ];then
            log_error "[check_internal_and_manag(),$LINENO] Can't find match rules for $G_MANAGE_FLOAT_IP and $param !"
            mismatch=1
        fi
            
        param="dpt:8088"
        ret=`echo "${netIptables}" |grep  $G_MANAGEMENT_IP.*$param.*$G_MANAGE_FLOAT_IP|wc -l`
        if [ $ret -eq 0 ];then
            log_error "[check_internal_and_manag(),$LINENO] Can't find match rules for $G_MANAGEMENT_IP to $param $G_MANAGE_FLOAT_IP!"
            mismatch=1
        fi
            
        param="dpt:443"
        ret=`echo "${netIptables}" |grep  $G_MANAGEMENT_IP.*$param.*$G_MANAGE_FLOAT_IP.*8088|wc -l`
        if [ $ret -eq 0 ];then
            log_error "[check_internal_and_manag(),$LINENO] Can't find match rules for $G_MANAGEMENT_IP to $param $G_MANAGE_FLOAT_IP 8088!"
            mismatch=1
        fi
           
        ret=`echo "${netIptables}" |grep  $G_MANAGE_FLOAT_IP.*$param.*$G_MANAGE_FLOAT_IP.*8088|wc -l`   
        if [ $ret -eq 0 ];then
            log_error "[check_internal_and_manag(),$LINENO] Can't find match rules for $G_MANAGE_FLOAT_IP to $param $G_MANAGE_FLOAT_IP 8088!"
            mismatch=1
        fi
            
        param="dpt:22"
        ret=`echo "${netIptables}" |grep  $G_MANAGE_FLOAT_IP.*$param.*$G_MANAGEMENT_IP|wc -l`   
        if [ $ret -eq 0 ];then
            log_error "[check_internal_and_manag(),$LINENO] Can't find match rules for $G_MANAGE_FLOAT_IP to $param $G_MANAGEMENT_IP !"
            mismatch=1
        fi
                    
        if [ $mismatch -eq 1 ];then
            return 1
        fi
    fi
        
    return 0
}

#******************************************************************#
# Function: status
# Description: The function to query the status of floatIP 
# Input Parameters:
# None
# Return : 0 running
#      2 stopped
#******************************************************************#
function status()
{
    if [ $IP_FLAG = 'ipv4' ];then
        log_info "[status(),$LINENO] benfin query floatIP status !"

        if [ $G_OS_TYPE == "Euler" ]; then
            ${G_IFCONFIG} ${G_MANAGE_FIP_PORT} 2> /dev/null | grep "inet" | grep "${G_MANAGE_FLOAT_IP}" > /dev/null
        else
            ${G_IFCONFIG} ${G_MANAGE_FIP_PORT} 2> /dev/null | grep "inet addr" | grep "${G_MANAGE_FLOAT_IP}" > /dev/null
        fi
        if [ $? -eq 0 ];then
            log_info "[status(),$LINENO] floatIP has been set !"
            return 0
        fi
        log_info "[status(),$LINENO] floatIP has been not set !"
        return 2
    else
        log_info "[status(),$LINENO] benfin query floatIP status !"

        if [ $G_OS_TYPE == "Euler" ]; then
            ${G_IFCONFIG} ${G_MANAGEMENT_ETH_NAME} 2> /dev/null | grep "inet6" | grep "${G_MANAGE_FLOAT_IP}" > /dev/null
        else
            ${G_IFCONFIG} ${G_MANAGE_FIP_PORT} 2> /dev/null | grep "inet6 addr" | grep "${G_MANAGE_FLOAT_IP}" > /dev/null
        fi
        if [ $? -eq 0 ];then
            log_info "[status(),$LINENO] floatIP has been set !"
            return 0
        fi
        log_info "[status(),$LINENO] floatIP has not been set !"
        return 2
    fi
}

#******************************************************************#
# Function: get_floatip_information
# Description: The function to get the floatip's information
# Input Parameters:
# None
# Return : 0 success
#          1 failed
#******************************************************************#
function get_floatip_information()
{
    if [ $IP_FLAG = 'ipv4' ];then
        G_MANAGE_FLOAT_IP=`GetFloatIP`
        if [ -z $G_MANAGE_FLOAT_IP ];then
            log_warn "[get_floatip_information(),$LINENO] get floatIP address faild"    
            return 1
        fi

        log_info "[get_floatip_information(),$LINENO] floatip=$G_MANAGE_FLOAT_IP" 

        G_MANAGEMENT_IP=`cat ${G_HCP_CONFIG_INI} | grep  "HCPManagementPlane=" |awk -F '|' '{print $1}' | grep "HCPManagementPlane" | awk -F '=' '{print $2}'`
        if [ -z $G_MANAGEMENT_IP ];then
            log_warn "[get_floatip_information(),$LINENO] get managementIP address faild"   
            return 1
        fi
        check_ip_address "${G_MANAGEMENT_IP}"
        if [ $? -ne 0 ];then
            log_warn "[get_floatip_information(),$LINENO] get managementIP address faild"
            return 1
        fi
           
        if [ $G_OS_TYPE == "Euler" ]; then
            G_MANAGE_FIP_MASK="`${G_IFCONFIG} 2> /dev/null | grep -w $G_MANAGEMENT_IP | awk '{print $4}'`"
        else
            G_MANAGE_FIP_MASK="`${G_IFCONFIG} 2> /dev/null | grep -w $G_MANAGEMENT_IP | awk -F ':' '{print $4}'`"
        fi
        if [ -z $G_MANAGE_FIP_MASK ];then
            log_warn "[get_floatip_information(),$LINENO] find  mask of managementIP faild" 
            return 1
        fi

        local L_MANAGEMENT_ETH_NAME=""
        local L_LIN=""
        L_LIN=`${G_IFCONFIG} 2> /dev/null | grep -n $G_MANAGEMENT_IP | head -1 |cut -d ":" -f 1`
        if [ -z $L_LIN ];then
            log_warn "[get_floatip_information(),$LINENO] find  device_name line number of managementIP faild"  
            return 1
        fi

        L_MANAGEMENT_ETH_NAME=`test $L_LIN -ne 1 && let L_LIN-- && ${G_IFCONFIG} 2> /dev/null | sed -n ${L_LIN}p  | awk -F '[ \t]*' '{print $1}'`
        if [ -z $L_MANAGEMENT_ETH_NAME ];then
            log_warn "[get_floatip_information(),$LINENO] find  device_name of managementIP faild"  
            return 1
        fi
        G_MANAGEMENT_ETH_NAME=$L_MANAGEMENT_ETH_NAME
        if [ $G_OS_TYPE == "Euler" ]; then
            L_MANAGEMENT_ETH_NAME=${L_MANAGEMENT_ETH_NAME%:*}
        fi
        G_MANAGE_FIP_PORT=$L_MANAGEMENT_ETH_NAME:mgr
        log_info "[get_floatip_information(),$LINENO] get floatIP info success,floatIP_eth_name=$G_MANAGE_FIP_PORT" 
        return 0    
    else
        G_MANAGE_FLOAT_IP=`GetFloatIP`
        if [ -z $G_MANAGE_FLOAT_IP ];then
            log_warn "[get_floatip_information(),$LINENO] get floatIP address faild"    
            return 1
        fi

        log_info "[get_floatip_information(),$LINENO] floatip=$G_MANAGE_FLOAT_IP" 

        G_MANAGEMENT_IP=`cat ${G_HCP_CONFIG_INI} | grep  "HCPManagementPlane=" |awk -F '|' '{print $1}' | grep "HCPManagementPlane" | awk -F '=' '{print $2}'`
        if [ -z $G_MANAGEMENT_IP ];then
            log_warn "[get_floatip_information(),$LINENO] get managementIP address faild"   
            return 1
        fi
        check_ip_address "${G_MANAGEMENT_IP}"
        if [ $? -ne 0 ];then
            log_warn "[get_floatip_information(),$LINENO] get managementIP address faild"
            return 1
        fi

        local L_MANAGEMENT_ETH_NAME=""
        local L_LIN=""
        L_LIN=`${G_IFCONFIG} 2> /dev/null | grep -n $G_MANAGEMENT_IP | head -1 |cut -d ":" -f 1`
        if [ -z $L_LIN ];then
            log_warn "[get_floatip_information(),$LINENO] find  device_name line number of managementIP faild"  
            return 1
        fi

        let L_LIN--
        L_MANAGEMENT_ETH_NAME=`${G_IFCONFIG} 2> /dev/null | sed -n ${L_LIN}p  | awk -F '[ \t]*' '{print $1}'`
        if [ -z ${L_MANAGEMENT_ETH_NAME} ];then
            while [ ${L_LIN} -ne 0 ]
            do
                let L_LIN--
                L_MANAGEMENT_ETH_NAME=`ifconfig 2> /dev/null | sed -n ${L_LIN}p  | awk -F '[ \t]*' '{print $1}'`
                if [ ! -z ${L_MANAGEMENT_ETH_NAME} ];then
                    break

                fi
            done
        fi
        if [ -z $L_MANAGEMENT_ETH_NAME ];then
            log_warn "find  device_name of InternelIP faild"
            return 1
        fi

        if [ $G_OS_TYPE == "Euler" ]; then
            L_MANAGEMENT_ETH_NAME=${L_MANAGEMENT_ETH_NAME%:*}
        fi
        G_MANAGE_FIP_PORT=$L_MANAGEMENT_ETH_NAME
        log_info "[get_floatip_information(),$LINENO] get floatIP info success,floatIP_eth_name=$G_MANAGE_FIP_PORT" 
        return 0
    fi
}

#******************************************************************#
# Function: check_hamode
# Description: The function to check mode of HA
# Input Parameters:
# None
# Return : 0 double mode 
# exit : 0 single mode
#******************************************************************#
function check_hamode()
{
    G_HA_MODE=`GetHAMode`
    if [ "X${G_HA_MODE}" == "Xsingle" ];then
        log_info "this is single mode"
        return 1
    else
        log_info "this is double mode"
        return 0
    fi

}

#******************************************************************#
# Function: clear_web_port
# Description: The function to clear web port
# Input Parameters:
# None
# Return : 0 success 
#      1 failed
#******************************************************************#

function clear_web_port()
{
    log_info "[clear_web_port(),$LINENO] execute the clear_web_port,but nothing running.";
}

#******************************************************************#
# Function: clear_float_ip
# Description: The function to clear floating ip
# Input Parameters:
# $1: IP addr
# Return : 0 success 
#      1 failed
#******************************************************************#
function clear_float_ip()
{
    if [ $# -ne 1 ];then
         log_error "invalid parameter, need input floating ip that will be cleared"
    fi
    
    G_MANAGE_FLOAT_IP=$1
    check_ip_addr ${G_MANAGE_FLOAT_IP}
    if [ $? -eq 1 ];then
        log_error "${G_MANAGE_FLOAT_IP} is not valid ip"
        return 1
    fi
    G_MANAGEMENT_IP=`cat ${G_HCP_CONFIG_INI} | grep  "HCPManagementPlane=" |awk -F '|' '{print $1}' | grep "HCPManagementPlane" | awk -F '=' '{print $2}'`
    if [ -z $G_MANAGEMENT_IP ];then
        log_error "get managementIP address failed when clear floating ip"  
        return 1
    fi
    check_ip_address "${G_MANAGEMENT_IP}"
    if [ $? -ne 0 ];then
        log_error "get managementIP address failed when clear floating ip"
        return 1
    fi

    local L_MANAGEMENT_ETH_NAME=""
    local L_LIN=""
    L_LIN=`${G_IFCONFIG} 2> /dev/null | grep -n -Fw $G_MANAGEMENT_IP | head -1 |cut -d ":" -f 1`
    if [ -z $L_LIN ];then
        log_error "get device_name info of managementIP failed when clear floating ip"  
        return 1
    fi

    L_MANAGEMENT_ETH_NAME=`test $L_LIN -ne 1 && let L_LIN-- && ${G_IFCONFIG} 2> /dev/null | sed -n ${L_LIN}p  | awk -F '[ \t]*' '{print $1}'`
    if [ -z $L_MANAGEMENT_ETH_NAME ];then
        log_error "get eth name of managementIP failed when clear floating ip"  
        return 1
    fi
    G_MANAGEMENT_ETH_NAME=$L_MANAGEMENT_ETH_NAME
    if [ $G_OS_TYPE == "Euler" ]; then
        L_MANAGEMENT_ETH_NAME=${L_MANAGEMENT_ETH_NAME%:*}
    fi
    
    G_MANAGE_FIP_PORT=$L_MANAGEMENT_ETH_NAME:mgr
    log_info "the eth name of floating ip is ${G_MANAGE_FIP_PORT}"
      
    sudo ${WORK_PATH}/sudofunction.sh unset_floatip ${G_MANAGE_FIP_PORT} ${G_MANAGE_FLOAT_IP}
    recover_iptables 
}

#******************************************************************#
# Function: standby_clear_ip
# Description: The function to clear floating ip for standby in abnarmol
# Input Parameters:None
# Return : 0 success 
#          1 failed
#******************************************************************#
function standby_clear_ip()
{
    if [ ! -f ${G_HAARB_XML} ];then
        log_error "standby_clear_ip(),${G_HAARB_XML} is not exist"
        return 1
    fi

    G_MANAGE_FLOAT_IP=`cat ${G_HAARB_XML} | grep "arpip value" | awk -F '=' '{print $2}' | tr -d  '/>"'`
    if [ -z ${G_MANAGE_FLOAT_IP} ];then
        log_info "standby_clear_ip(), there is no floatIP,so it's no use to clear "
        return 0
    fi
    check_ip_address "${G_MANAGE_FLOAT_IP}"
    if [ $? -ne 0 ];then
        log_info "standby_clear_ip(), there is no floatIP,so it's no use to clear "
        return 1
    fi

    local L_MANAGEMENT_ETH_NAME=""
    local L_LIN=""
    L_LIN=`${G_IFCONFIG} 2> /dev/null | grep -n ${G_MANAGE_FLOAT_IP} | head -1 |cut -d ":" -f 1`
    if [ -z $L_LIN ];then
        log_info "get device_name info of ${G_MANAGE_FLOAT_IP} failed when clear floating ip,so it's no use to clear "
        return 0
    fi

    L_MANAGEMENT_ETH_NAME=`test $L_LIN -ne 1 && let L_LIN-- && ${G_IFCONFIG} 2> /dev/null | sed -n ${L_LIN}p  | awk -F '[ \t]*' '{print $1}'`
    if [ $? -ne 0 ];then
        log_info "get device_name info of ${G_MANAGE_FLOAT_IP} failed when clear floating ip,so it's no use to clear "
        return 0
    fi
    G_MANAGEMENT_ETH_NAME=$L_MANAGEMENT_ETH_NAME
    if [ $G_OS_TYPE == "Euler" ]; then
        L_MANAGEMENT_ETH_NAME=${L_MANAGEMENT_ETH_NAME%:*}
    fi
    G_MANAGE_FIP_PORT=`echo "$L_MANAGEMENT_ETH_NAME" | awk -F ' ' '{print $1}'`
    
    log_info "the eth name of floating ip is ${G_MANAGE_FIP_PORT}"

    sudo ${WORK_PATH}/sudofunction.sh unset_floatip ${G_MANAGE_FIP_PORT} ${G_MANAGE_FLOAT_IP}
    return $?
}

function check_ip_flag()
{
    IP_FLAG=`cat ${G_CONF_PATH}| grep "NetworkType" | awk -F '=' '{print $2}'`
    if [ -z $IP_FLAG ];then
        IP_FLAG="ipv4"
    fi

    if [ $IP_FLAG != "ipv4" ];then
       G_NDSEND="$(which ndsend)"
    fi
}


#******************************************************************#
# Function: main
# Description: main
# Input Parameters:action
# Return : 0 double mode 
#exit code:
# single / active-active
#   0 = normal
#   1 = abnormal
#   2 = stop
#   3 = unknown
#   4 = starting
#   5 = stopping
#   10 = invaild action
#
# active-standby
#   1 = abnormal
#   2 = stop
#   3 = unknown
#   6 = active normal
#   7 = standby normal
#   8 = switching to active
#   9 = switching to standby
#   10 = invaild action
#******************************************************************#
function main ()
{
    checkout_os_type
    check_ip_flag
    if [ "X$1" == "Xclear_web_port" ];then
        clear_web_port
        exit $?
    elif [ "X$1" == "Xclear_ip" ];then
        shift 1 && clear_float_ip $@            
        exit $?
    elif [ "X$1" == "Xstandby_clear_ip" ];then
        standby_clear_ip
        exit $?
    fi  

    check_hamode
    if [[ $? -ne 0 && ! -f $G_FLOAT_IP_BAK ]];then
        log_info "ha mode is single and floatIpBak not exist, it's indicate never add ha!"
        if [ "$1" != "stop" ];then
           exit 0
        fi
    fi

    case $1 in
    status)
        sleep $[ ( $RANDOM % 3 ) ]s
        get_floatip_information
        if [ $? -ne 0 ];then    
            exit 2
        fi

        check_internal_and_manag
        if [ $? -eq 1 ];then
            exit 1
        fi  
        status
        exit $?
        ;;
    repair)
        repair
        if [ $? -ne 0 ];then
            exit 1
        fi
        ;;
    start)
        get_floatip_information
        if [ $? -ne 0 ];then
            exit 1
        fi
        set_floatip
        exit $?
        ;;
    stop)
        get_floatip_information
        sudo ${WORK_PATH}/sudofunction.sh unset_floatip ${G_MANAGE_FIP_PORT} ${G_MANAGE_FLOAT_IP}
        exit 0
        ;;
    force-stop)
        get_floatip_information
        sudo ${WORK_PATH}/sudofunction.sh unset_floatip ${G_MANAGE_FIP_PORT} ${G_MANAGE_FLOAT_IP}
        exit 0
        ;;
    notify)
        local L_EVENT_TYPE=$4
        local L_NODE_NAME=$5
        if [ $L_EVENT_TYPE == 1 ];then
            ProcessFloatIPAbnormalAlarm 0 "$L_NODE_NAME"
        else
            ProcessFloatIPAbnormalAlarm 1
        fi

        exit $?
        ;;
    diagnose)
        ${G_HCP_ROOT}/ha/module/hacom/tools/ha_client_tool --clearrmfault --name=${G_RESOURCE_NAME}
        if [ $? -ne 0 ];then
            log_error "ha_client_tool --clearrmfault --name=${G_RESOURCE_NAME} failed!"
            exit 1
        fi
        log_info "ha_client_tool --clearrmfault --name=${G_RESOURCE_NAME} success!"
        exit 0
        ;;
    *)
        echo "Parameter incorrect."
        exit 1
        ;;
    esac
}

G_ROLE=$2
main "$@"


